package gov.va.genisis2.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/**
 * The Class RequestType.
 * 
 * Description: In this RequestType Class implements the interface Serializable
 * and defines the entity and data mapping for the dbo.User_Approver Table in
 * the database.
 */
@Entity
@Table(name = "RequestType", schema = "dbo")
public class RequestType implements Serializable {

	/**
	 * serialVersionUID field for serializable class
	 */
	private static final long serialVersionUID = -7137132462197853036L;

	/** The id. */
	@Id
	@Column(name = "Id", unique = true, nullable = false)
	private int id;
	
	/** The description. */
	@Column(name = "Description", length = 50)
	private String description;
	
	/** The Requests */
	@OneToMany(fetch=FetchType.LAZY, mappedBy="source")
	private Set<Request> requests = new HashSet<>(0);

	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	public int getId() {
		return this.id;
	}

	/**
	 * Sets the id.
	 *
	 * @param id the new id
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * Gets the description.
	 *
	 * @return the description
	 */
	public String getDescription() {
		return this.description;
	}

	/**
	 * Sets the description.
	 *
	 * @param description the new description
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	
	/** Gets Request
	 * @return Returns Request
	 */
    public Set<Request> getRequests() {
        return this.requests;
    }
    
	/**
	 * Sets the requests
	 *
	 * @param requests the requests
	 * 
	  */
    public void setRequests(Set<Request> requests) {
        this.requests = requests;
    }
}
